﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Runtime.InteropServices;

namespace PInvoke
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            string katalogGlownyDysku = System.Environment.GetLogicalDrives()[0]; //"C:\\"
            int procentZajetosci = wolneMiejsceNaDysku(katalogGlownyDysku);
            if (procentZajetosci >= 0) progressBar1.Value = procentZajetosci;

            //Zmiana lokalizacji pasjansa w Windows Vista i Windows 7
            if (System.Environment.OSVersion.Version.Major >= 6) textBox1.Text = @"c:\Program Files\Microsoft Games\Solitaire\solitaire.exe";
        }

        [DllImport("User32.dll")]
        static extern bool MessageBeep(uint rodzajDzwieku);

        private void button1_Click(object sender, EventArgs e)
        {
            MessageBeep(0);            
        }

        private void button2_Click(object sender, EventArgs e)
        {
            MessageBeep(48);
        }

        [DllImport("kernel32.dll")]
        static extern uint WinExec(string polecenie, uint stanOkna);

        enum StyleOkna : uint { Ukryte = 0, Normalme, Zminimalizowane, Zmaksymalizowane, Nieaktywne, Domyslne = 10 };

        private void button3_Click(object sender, EventArgs e)
        {
            uint wynik = WinExec(textBox1.Text, (uint)StyleOkna.Normalme);
            if (wynik <= 31)
                MessageBox.Show("Błąd " + wynik + "! Nie udało się uruchomić " + textBox1.Text);
        }

        [DllImport("kernel32.dll")]
        public static extern bool GetDiskFreeSpaceEx(
            string katalog, 
            ref long wolneMiejsceDlaUzytkownika, 
            ref long rozmiarDysku, 
            ref long wolneMiejsceNaDysku);

        private int wolneMiejsceNaDysku(string katalogGlownyDysku)
        {
            int wolneMiejsceNaDyskuProcenty;
            long wolneMiejsceDlaUzytkownika = 0;
            long rozmiarDysku = 0;
            long wolneMiejsceNaDysku = 0;
            if (GetDiskFreeSpaceEx(katalogGlownyDysku,
                  ref wolneMiejsceDlaUzytkownika,
                  ref rozmiarDysku,
                  ref wolneMiejsceNaDysku))
            {
                wolneMiejsceNaDyskuProcenty = (int)(100 * (rozmiarDysku - wolneMiejsceNaDysku) / (double)rozmiarDysku);
            }
            else
            {
                wolneMiejsceNaDyskuProcenty = -1;
            }
            return wolneMiejsceNaDyskuProcenty;
        }

        [DllImport("kernel32.dll")]
        static extern uint GetWindowsDirectory(StringBuilder bufor, uint rozmiarBufora);

        private void button4_Click(object sender, EventArgs e)
        {
            const int MAX_PATH = 260;
            StringBuilder katalogWindows = new StringBuilder(MAX_PATH);
            uint rozmiar = (uint)katalogWindows.Capacity;
            GetWindowsDirectory(katalogWindows, rozmiar);
            MessageBox.Show(katalogWindows.ToString());
        }

    }
}
